define([
    'underscore',
    'marionette',
    'User',

    'modules/appointments/requested/request-messages-desc-view',
    'modules/appointments/requested/request-new-message-form-view',
    'modules/appointments/requested/request-messages-view',

    'text!modules/appointments/requested/request-messages-layout.html',
], function(
    _,
    Marionette,
    User,
    MessagesDescView,
    NewMessageFormView,
    MessagesView,
    template
) {
    'use strict';

    return Marionette.View.extend({
        template: _.template(template),
        regions: {
            informationalTextRegion: '#request-messages-info',
            newMessageFormRegion: '#request-messages-new',
            messagesRegion: '#request-messages-bubbles',
        },
        modelEvents: {'change:status': 'showNewMessageFormView showMessagesView'},
        collectionEvents: {'sync': 'showNewMessageFormView showMessagesView'},
        onRender: function() {
            this.showMessagesDescView();
            this.showNewMessageFormView();
            this.showMessagesView();
        },
        onDestroy: function() {
            delete this.newMessageFormView;
            delete this.messagesView;
        },
        showMessagesDescView: function() {
            var informationalTextRegion = this.getRegion('informationalTextRegion');

            if (!this.isDestroyed()) {
                if (!this.messagesDescView) {
                    this.messagesDescView = new MessagesDescView({
                        model: this.model,
                        collection: this.collection,
                    });
                }
                informationalTextRegion.show(this.messagesDescView);
            }
        },
        showNewMessageFormView: function() {
            var newMessageFormRegion = this.getRegion('newMessageFormRegion');
            if (!this.isDestroyed()) {
                if (!this.newMessageFormView) {
                    this.newMessageFormView = new NewMessageFormView({
                        id: 'new-message-form',
                        model: this.model,
                        collection: this.collection,
                    });
                }
                
                // eslint-disable-next-line no-magic-numbers
                if (this.model.get('status') === 'Submitted' && this.collection.getVeteranMessageCount() < 2) {
                    newMessageFormRegion.show(this.newMessageFormView);
                } else {
                    newMessageFormRegion.empty();
                }
            }
        },
        showMessagesView: function() {
            var messagesRegion = this.getRegion('messagesRegion');

            if (!this.isDestroyed() && this.collection.length > 0) {
                if (!this.messagesView) {
                    this.messagesView = new MessagesView({
                        id: 'request-messages-log',
                        model: this.model,
                        collection: this.collection,
                    });
                }
                messagesRegion.show(this.messagesView);
            }
        },
    });
});
